import java.io.* ;
import java.util.* ;
import java.awt.image.BufferedImage;

public class ImageComputationThread extends Thread {

	private Chromozome[] chromozomes;
	private ArtPanel artPanel;
	private int IMAGE_SIZE;
	private boolean red, green, blue;

	 public ImageComputationThread(Chromozome[] chr, ArtPanel panel, int imageSize, boolean r, boolean g, boolean b)
	 {
		 chromozomes = chr;
		 artPanel = panel;
		 IMAGE_SIZE = imageSize;

		 red = r;
		 green = g;
		 blue = b;
	 }

	 public void run()
	 {
		for(int i = 0; i < chromozomes.length; i++)
		{
			PreCombinedImage image = new PreCombinedImage(GeneticOperators.calculateImage(chromozomes[i], IMAGE_SIZE, IMAGE_SIZE));
			artPanel.setPreCombinedImage(i, image);

		 	int[] tempImage = image.combineImage(red, green, blue);
			BufferedImage tempBufferedImage = new BufferedImage(IMAGE_SIZE, IMAGE_SIZE, BufferedImage.TYPE_INT_ARGB);
		 	tempBufferedImage.setRGB(0, 0, IMAGE_SIZE, IMAGE_SIZE, tempImage, 0, IMAGE_SIZE);
		 	artPanel.setBufferedImage(i, tempBufferedImage);
		}

		artPanel.threadCompletedComputation();
	 }
}